// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#include <math.h>
#include <vector>
#include <set>
#include <fstream>
#include <iomanip>
#include <stack>

//#define USER_CONTROL
//#define PRINT_DEBUG_INFO
//#define USE_NETWORK_THREAD
//#define WRITE_FRAMES
#define READ_FRAMES

#if defined WRITE_FRAMES && defined READ_FRAMES
#error Nur eins definieren;)
#endif

//Wir knnen anhand des blinkenden "PUSH START" oder "STARTKNOEPFE DRUECKEN" ablesen, wie der 
//interne Timer von Asteroids in den ersten 6 Bits ist.
//Das ist von groem Vorteil, weil der Timer der Schsse und das UFO nur alle 4 Frames aktualisiert
//werden und wir deshalb unbedingt das 2 Bit vom Timer wissen mssen. (Das erste ist leicht wegen dem
//Doublebuffering abzulesen).
//Weil aber leider nichts blinkt, wenn man die Initialien fr den Highscore eingeben muss, musste
//ich leider erheblich viel Code hinzufgen, um das zweite Bit herauszufinden, wenn man das Start
//nicht mitkriegt...
//#define DETECT_START_FOR_TIMERBITS

inline void assert(bool b)
{
	if(b)
		return;
	printf("Assertion fehlgeschlagen!\n");
	while(true)
		;
	MessageBox(0, "Assertion fehlgeschlagen..", "Asteroids KI", 0);
}

inline void SetTrue(bool& x)
{
	x = true;
}

#define VRamAssert(x, y) do{if(!(x)){SetTrue(y); return true;}}while(false)

extern bool ValidateKIGame;

template<typename T>
void assert(bool b, const T& Exc)
{
	if(!b)
		throw Exc;
}

/*
class VRamInvalidException
{
};
*/
class KIGameInvalidException
{
};

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int uint;
const int MaxInt = 0x7FFFFFFF;

//#pragma warning( disable: 4309)


//Diese Klasse ist sehr an dieses Projekt angepasst und ist alles andere als vollstndig
template<uint cBits>
class BitArray
{
	byte Bits[(cBits+7)/8];
	uint cSetBits;
	mutable uint FirstSetBit;
public:
	bool Get(uint Index) const
	{
		assert(Index < cBits);

		byte Mask = 1 << (Index - Index / 8 * 8);

		return (Bits[Index/8] & Mask) != 0;
	}

	void Set(uint Index, bool b)
	{
		if(Get(Index) == b)
			return;
		assert(Index < cBits);

		byte Mask = 1 << (Index - Index / 8 * 8);

		if(b)
		{
			Bits[Index/8] |= Mask;
			cSetBits++;
			if(Index < FirstSetBit)
				FirstSetBit = Index;
		}
		else
		{
			Bits[Index/8] &= ~Mask;
			cSetBits--;
		}
	}

	void SetAll()
	{
		for(uint i = 0; i < (cBits+7)/8; i++)
			Bits[i] = 0xFF;
		cSetBits = cBits;
		FirstSetBit = 0;
	}
	void ClearAll()
	{
		for(uint i = 0; i < (cBits+7)/8; i++)
			Bits[i] = 0;
		cSetBits = 0;
		FirstSetBit = cBits;
	}
	void RotateRight()
	{
		if(cSetBits == 1)
		{
			GetFirstSetIndex();
			Set(FirstSetBit, false);
			FirstSetBit = (FirstSetBit+1)%cBits;
			Set(FirstSetBit, true);
			assert(cSetBits == 1);
		}
		else if(cSetBits != cBits)
		{
			//Das kann man noch gewaltig optimieren...
			bool Last = Get(cBits-1);
			for(uint i = cBits-1; i >= 1; i--)
				Set(i, Get(i-1));
			Set(0, Last);
		}
	}
	int GetFirstSetIndex() const
	{
		assert(cSetBits != 0);
		while(!Get(FirstSetBit))
			FirstSetBit = (FirstSetBit+1) % cBits;
		return FirstSetBit;
/*		if(cSetBits == 0)
			return -1;
		for(int i = 0; i < cBits; i++)
			if(Get(i))
				return i;
		assert(0);
		return -1;*/
	}
	int GetNumSetBits() const
	{
		return cSetBits;
	}

	//Achtung: Nach dem diese Methode aufgerufen wurde muss
	//unbedingt UpdateInternalData() aufgerufen werden!
	void operator |=(const BitArray& rhs)
	{
		for(int i = 0; i < (cBits+7)/8; i++)
			Bits[i] |= rhs.Bits[i];
	}
	void UpdateInternalData()
	{
		cSetBits = 0;
		FirstSetBit = 0;
		for(int i = 0; i < cBits; i++)
			if(Get(i))
			{
				cSetBits++;
				if(FirstSetBit == cSetBits)
					FirstSetBit = i;
			}
	}
};


class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	void clear(void);
};

enum Direction
{
	Dir_Left,
	Dir_None,
	Dir_Right
};


enum
{
	Key_Hyperspace = 1,
	Key_Fire = 2,
	Key_Thrust = 4,
	Key_Right = 8,
	Key_Left = 16
};

inline byte KeyFromDirection(Direction Dir)
{
	byte Key = 0;
	if(Dir == Dir_Left)
		Key |= Key_Left;
	if(Dir == Dir_Right)
		Key |= Key_Right;
	return Key;
}


/*
class KeysPacket
{
private:
	char signature[6];
public:
	static const byte KEY_HYPERSPACE = 1;
	static const byte KEY_FIRE = 2;
	static const byte KEY_THRUST = 4;
	static const byte KEY_RIGHT = 8;
	static const byte KEY_LEFT = 0x10;

	byte keys;
	byte Ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
	void SwapDirection()
	{
		if(keys & KEY_LEFT)
		{
			assert((keys&KEY_RIGHT) == 0);
			left(false);
			right(true);
		}
		else if(keys&KEY_RIGHT)
		{
			assert((keys&KEY_LEFT) == 0);
			left(true);
			right(false);
		}
	}
	void FromDirection(Direction Dir)
	{
		left(Dir == Dir_Left);
		right(Dir == Dir_Right);
	}
};
*/


const int cAsteroids = 27;
const int cPlayerShots = 4;
const int cSaucerShots = 2;

enum
{
	AsteroidMinIndex,
	AsteroidMaxIndex = AsteroidMinIndex+cAsteroids-1,
	PlayerIndex,
	SaucerIndex,
	SaucerShotMinIndex,
	SaucerShotMaxIndex = SaucerShotMinIndex+cSaucerShots-1,
	PlayerShotMinIndex,
	PlayerShotMaxIndex = PlayerShotMinIndex+cPlayerShots-1,
	NumObjects
};

const int ShotLifetime = 0x12 * 4;
const int RotationSpeed = 3;

inline word MoveLinearX(word PositionX, char VelocityX, int Steps)
{
	assert(Steps >= 0);
	if(Steps == 0)
		return PositionX;
	else
		return (PositionX + VelocityX*Steps) & 0x1FFF;
/*	word oldPositionX = PositionX;
	for(int i = 0; i < Steps; i++)
	{
		PositionX += char(VelocityX);
		if(PositionX >= 0x2000)//Objekt geht rechts raus
		{
			PositionX &= 0x1FFF;//links wieder rein
		}
	}
	if(PositionX != ((oldPositionX+char(VelocityX)*Steps)&0x1FFF))
		VRamAssert(0);
	return PositionX;*/
}

inline word MoveLinearY(word PositionY, char VelocityY, int Steps)
{
	assert(Steps >= 0);
	if(Steps == 0)
		return PositionY;
	//const word PositionYIn = PositionY;
	//word oldPositionY = PositionY;

	PositionY += VelocityY;
	if((PositionY & 0xFF00) == 0x1800)//Objekt geht unten raus
		PositionY = 0x0000 | (PositionY & 0x00FF);
	else if(PositionY >= 0x1800)
		PositionY = 0x1700 | (PositionY & 0x00FF);

	PositionY += VelocityY*(Steps-1);
	if(VelocityY >= 0)
	{
		while(PositionY >= 0x1800)
			PositionY -= 0x1800;
	}
	else
		while(PositionY >= 0x1800)
			PositionY += 0x1800;
	return PositionY;

/*	for(int i = 0; i < Steps; i++)
	{
		oldPositionY += VelocityY;
		if((oldPositionY & 0xFF00) == 0x1800)//Objekt geht unten raus
		{
			oldPositionY = 0x0000 | (oldPositionY&0x00FF);
		}
		else if(oldPositionY >= 0x1800)
		{
			oldPositionY = 0x1700 | (oldPositionY&0x00FF);
		}
	}
	if(PositionY != oldPositionY)
		VRamAssert(0);
	return PositionY;*/
}
struct ShotInfo
{
public:
	ShotInfo()
	{
		Time = MaxInt;
	}
public:
	int Time;
	Direction Dir;
	byte TargetDirection;
	int CollisionTime;
	bool RotationWasLocked;

	int ShotIndex;
	word PositionX, PositionY;
	int Target;
	word StartX, StartY;
	char VelocityX, VelocityY;
	word TargetPositionX, TargetPositionY;
	char TargetStatus;
	byte StartDirection;
};

extern __int64* pScore;

inline word MakeWord(byte high, byte low)
{
	return word(high)<<8 | word(low);
}
inline void MakeBytesFromWord(word Word, byte& High, byte& Low)
{
	High = byte(Word>>8);
	Low = byte(Word);
}
inline byte& LowByte(word& Word)
{
	return (byte&)Word;
}
inline byte& HighByte(word& Word)
{
	return *(((byte*)&Word)+1);
}
inline byte Half(byte value)
{
	if(char(value) >= 0)
		return value/2;
	else
		return char(value-1)/2;
}
inline void Clamp(byte& value, byte min, byte max)
{
	if(char(value) >= 0)
	{
		if(value > max)
			value = max;
	}
	else
	{
		if(value < min)
			value = min;
	}
}
template<typename T>
T Min(T a, T b)
{
	return a < b ? a : b;
}
template<typename T>
T Max(T a, T b)
{
	return a > b ? a : b;
}
inline word DecimalToBin(byte High, byte Low)
{
	return (High>>4)*1000 + (High&0x0F)*100 + (Low>>4)*10 + (Low&0x0F);
}
inline void BinToDecimal(word Bin, byte& High, byte& Low)
{
	Low = Bin%10;
	Bin /= 10;
	Low |= Bin%10 << 4;
	Bin /= 10;
	High = Bin%10;
	Bin /= 10;
	High |= Bin%10 << 4;
}
inline byte& ShiftLeft(byte& byte, bool& carry)
{
	carry = (byte>>7) != 0;
	byte <<= 1;
	return byte;
}
inline byte& RotateLeft(byte& byte, bool& carry)
{
	bool newcarry = (byte>>7) != 0;
	byte <<= 1;
	if(carry) byte |= 1;
	carry = newcarry;
	return byte;
}
inline byte& ShiftRight(byte& byte, bool& carry)
{
	carry = (byte&1) != 0;
	byte >>= 1;
	return byte;
}
inline byte& RotateRight(byte& byte, bool& carry)
{
	bool newcarry = (byte&1) != 0;
	byte >>= 1;
	if(carry) byte |= 0x80;
	carry = newcarry;
	return byte;
}
inline byte& Add(byte& a, byte b, bool& carry)
{
	int sum = a + int(b) + (carry ? 1 : 0);
	carry = (sum & 0xFF00) != 0;
	a = (byte)sum;
	return a;
}
inline byte& Subtract(byte& a, byte b, bool& carry)
{
	int c = (carry ? 1 : 0) ^ 1;
	int dif = a - int(b) - c;
	carry = (dif & 0xff00) == 0;
	a = (byte)dif;
	return a;
}

inline int NeededRotation(byte StartDir, byte GoalDir, Direction Dir)
{
	if(Dir == Dir_None)
	{
//		VRamAssert(StartDir == GoalDir);
		return 0;
	}
	int DeltaDir = 0;
	while(byte(StartDir+DeltaDir) != GoalDir)
		DeltaDir += (Dir == Dir_Left ? RotationSpeed : -RotationSpeed);
	return DeltaDir;
}
inline int NeededRotationTime(byte StartDir, byte GoalDir, Direction Dir)
{
	if(Dir == Dir_None)
	{
		assert(StartDir == GoalDir);
		return 0;
	}
	int DeltaDir = 0;
	int Time = 0;
	while(byte(StartDir+DeltaDir) != GoalDir)
	{
		DeltaDir += (Dir == Dir_Left ? RotationSpeed : -RotationSpeed);
		Time++;
	}
	return Time;
}

const int MaxLocations = 256;
class Object
{
public:
	char Status; //Negativ: Objekt explodiert gerade.
				 //0: Objekt nicht vorhanden.
				 //Positiv: Je nach Objekttyp. Bei...
				 //                            Asteroiden: Gre (1=klein, 2=mittel, 4=gro) Auerdem ist in den Bits 3 und 4 der Anzeigetyp gespeichert
				 //                            Spieler: immer 1
				 //							   UFO: 2 (gro) oder 1 (klein)
				 //                            Schsse: ein herunterlaufender Timer. Im Original wird dieser alle 4 Frames dekrementiert. Ich setze ihn am Anfang auf das vierfache und dekrementiere jeden Frame.
	union
	{
		word PositionX;
		word PX[MaxLocations];
	};
	union
	{
		char VelocityX;
		char VX[MaxLocations];
	};
	int cX;
	union
	{
		word PositionY;
		word PY[MaxLocations];
	};
	union
	{
		char VelocityY;
		char VY[MaxLocations];
	};
	int cY;
public:
	Object()
	{
	}

	Object(char Status)
	{
		this->Status = Status;
		cX = cY = 0;
	}

	void SetVelocity(char X, char Y)
	{
		for(int i = 0; i < cX; i++)
			VX[i] = X;
		for(int i = 0; i < cY; i++)
			VY[i] = Y;
		RemoveEqualities();
	}
	bool SetVRamLocation(int x, int y, int VRamCounter, bool& VRamInvalid)
	{
		assert(!VRamInvalid);
		//printf("vg: %x %x  cx: %i cy: %i\n", x*8, (y-128)*8, cX, cY);
		if(VRamCounter == 1)
		{
			for(int i = 0; i < 8; i++)
			{
				PX[i] = x*8+i;
				PY[i] = (y-128)*8+i;
			}
			cX = cY = 8;
		}
		else if(VRamCounter == 2)
		{
			assert(cX == 8 && cY == 8);
			for(int i = 0; i < 8; i++)
			{
				PX[i+8] = x*8+i;
				PY[i+8] = (y-128)*8+i;
			}
			cX = cY = 16;
		}
		else if(VRamCounter == 3)
		{
			assert(cX == 16 && cY == 16);

			word P1[8];
			memcpy(P1, PX, sizeof(word)*8);
			word P2[8];
			memcpy(P2, PX+8, sizeof(word)*8);
			word P3[8];
			for(int i = 0; i < 8; i++)
				P3[i] = x*8+i;
			cX = 0;
			char NewVX = -128;
			do
			{
				for(int i = 0; i < 8; i++)
				{
					if(IsSet(MoveLinearX(P1[i], NewVX, 1), P2) && IsSet(MoveLinearX(P1[i], NewVX, 2), P3))
					{
						assert(cX < MaxLocations);
						PX[cX] = P1[i];
						VX[cX++] = NewVX;
					}
				}
			}while(++NewVX != -128);

			memcpy(P1, PY, sizeof(word)*8);
			memcpy(P2, PY+8, sizeof(word)*8);
			for(int i = 0; i < 8; i++)
				P3[i] = (y-128)*8+i;
			cY = 0;
			char NewVY = -128;
			do
			{
				for(int i = 0; i < 8; i++)
				{
					if(IsSet(MoveLinearY(P1[i], NewVY, 1), P2) && IsSet(MoveLinearY(P1[i], NewVY, 2), P3))
					{
						assert(cY < MaxLocations);
						PY[cY] = P1[i];
						VY[cY++] = NewVY;
					}
				}
			}while(++NewVY != -128);

			VRamAssert(cX && cY, VRamInvalid);
			MoveLinear(2);
		}
		else if(VRamCounter == 0)
		{
			//for(int i = 0; i < cX; i++)
			//	printf("%x oder ", PX[i]);
			for(int i = 0; i < cX;)
			{
				if(PX[i]/8 != x)
					RemoveX(i);
				else
					i++;
			}
			for(int i = 0; i < cY;)
			{
				if(PY[i]/8 != y-128)
					RemoveY(i);
				else
					i++;
			}
			VRamAssert(cX && cY, VRamInvalid);
		}
		else
			assert(0);
		return false;
	}
	void AddLocation(word PositionX, word PositionY, char VelocityX, char VelocityY)
	{
		AddLocationX(PositionX, VelocityX);
		AddLocationY(PositionY, VelocityY);
	}
	void AddLocationX(word PositionX, char VelocityX)
	{
		for(int i = 0; i < cX; i++)
		{
			if(PositionX == PX[i] && VelocityX == VX[i])
				return;
		}
		assert(cX != MaxLocations);
		if(cX == MaxLocations)
			return;
		PX[cX] = PositionX;
		VX[cX] = VelocityX;
		cX++;
	}
	void AddLocationY(word PositionY, char VelocityY)
	{
		for(int i = 0; i < cY; i++)
		{
			if(PositionY == PY[i] && VelocityY == VY[i])
				return;
		}
		assert(cY != MaxLocations);
		if(cY == MaxLocations)
			return;
		PY[cY] = PositionY;
		VY[cY] = VelocityY;
		cY++;
	}
	void SetVelocityY(char VelocityY)
	{
		for(int i = 0; i < cY; i++)
			VY[i] = VelocityY;
		RemoveEqualities();
	}
	void Decide(int IndexX, int IndexY)
	{
		PositionX = PX[IndexX];
		VelocityX = VX[IndexX];
		PositionY = PY[IndexY];
		VelocityY = VY[IndexY];
		cX = cY = 1;
	}
	bool IsFixed() const
	{
		return cX == 1 && cY == 1;
	}
	void SetFixed()
	{
		cX = cY = 1;
	}
	bool IsValid() const
	{
		return cX && cY;
	}
	void MoveLinear(int Steps)
	{
		for(int i = 0; i < cX; i++)
			PX[i] = MoveLinearX(PX[i], VX[i], Steps);
		for(int i = 0; i < cY; i++)
			PY[i] = MoveLinearY(PY[i], VY[i], Steps);
	}
	void ValidatePosition(word PositionX, word PositionY, char VelocityX, char VelocityY) const
	{
		for(int i = 0; i < cX; i++)
		{
			if(PositionX == PX[i] && VelocityX == VX[i])
			{
				for(int i = 0; i < cY; i++)
					if(PositionY == PY[i] && VelocityY == VY[i])
						return;
				assert(0);
			}
		}
		assert(0);
	}
	void RemoveEqualities()
	{
		for(int i = 0; i < cX; i++)
		for(int j = i+1; j < cX;)
			if(PX[i] == PX[j] && VX[i] == VX[j])
				RemoveX(j);
			else
				j++;

		for(int i = 0; i < cY; i++)
		for(int j = i+1; j < cY;)
			if(PY[i] == PY[j] && VY[i] == VY[j])
				RemoveY(j);
			else
				j++;
	}
	void RemoveX(int Index)
	{
		assert(cX && Index < cX);
		cX--;
		memcpy(PX+Index, PX+Index+1, (cX-Index)*sizeof(word));
		memcpy(VX+Index, VX+Index+1, (cX-Index)*sizeof(char));
	}
	void RemoveY(int Index)
	{
		assert(cY && Index < cY);
		cY--;
		memcpy(PY+Index, PY+Index+1, (cY-Index)*sizeof(word));
		memcpy(VY+Index, VY+Index+1, (cY-Index)*sizeof(char));
	}

private:
	static bool IsSet(word Item, const word* Array)
	{
		for(int i = 0; i < 8; i++)
			if(Array[i] == Item)
				return true;
		return false;
	}
};

enum MovePositionType
{
	MPT_Start,
	MPT_Shoot,
	MPT_UpdateSaucer,
	MPT_UpdateShots,
	MPT_ObjectCollision,
	MPT_ResetAsteroids
};

template<typename T>
class MovePosition
{
public:
	T Game;
	MovePositionType Type;
	bool SkipRemainingIfSuccessful;//Wenn das Spiel funktioniert hat, mit dem weiter gerechnet wurde,
								   //kann dieses Spiel nicht funktionieren. Man kann es also gleich ignorieren.

	int CollisionCauser, Target;//Wenn Type == MPT_ObjectCollision
public:
	MovePosition(MovePositionType Type, bool SkipRemainingIfSuccessful)
	{
		this->Type = Type;
		this->SkipRemainingIfSuccessful = SkipRemainingIfSuccessful;
	}
};


//#include "AsteroidStartPositions.h"
#include "RandomSeeds.h"
#include "ShipDirections.h"

class ShotInfoList;
class ObjectsStateList;
class GameRam
{
public:
	int CurrentTime; //Eigner globaler Zeitzhler. Wird am Ende von Move inkrementiert.
	int VRamCounter;
	int GameStartedTime;

#ifdef DETECT_START_FOR_TIMERBITS
	bool StartPrintedLastFrame, StartSwapNoticed;
#endif
	byte NumPlayers;
private:
	int Score;  //Asteroids speichert den Score anders, nmlich in 2 Bytes und in dezimal. Ja richtig, DEZIMAL!
				//Wenn man also beispielsweise 12340 Punkte hat, ist in dem einem Byte 0x12 (=18) drin und in
				//dem anderen 0x34 (=52). Die 0 am Ende ist nur Deko.
				//Wir speichern den Score ohne berlauf.
	byte NumShips;
	char HyperSpaceStatus;
public:
	byte Timer; //Wird jeden Frame inkrementiert. Das Original nimmt sich dafr eigentlich sogar 2 Bytes,
				//benutzt aber effektiv noch nichtmal das erste Byte, sondern nur die ersten 7 Bits.
				//Mag sein, dass hhere Bits fr Sachen benutzt werden, die ich mir nicht weiter angeschaut
				//habe (vielleicht der Wechsel zur Highscoreanzeige im Men)
	int TimerBitsKnown; //Wie viele Bits vom Timer bekannt sind.
						//Das erste lsst sich leicht ber den Backbuffer herausfinden, da dieser
						//synchron mit dem Timer wechselt.
						//Die ersten 6 lassen sich auf einen Schlag bestimmen, wenn man "PUSH START"
						//zweimal blinken sieht
						//Falls man das nicht tut, kann man die ersten beiden bestimmen, weil
						//das UFO nur auftaucht, wenn die ersten beiden Bits nicht gesetzt sind.
						//Das 7te entscheidet mit, ob das UFO die Richtung wechseln soll, lsst sich also
						//so bestimmen.
						//Das letzte hat, wie gesagt, keinen Einfluss auf das Spielgeschehen und lsst sich
						//deshalb auch nicht bestimmen.
//	byte RandomSeed1, RandomSeed2;
	BitArray<NumSeedCombinations> RandomSeedDistribution;
	byte ShipDirection;  //Die Richtung des Schiffes, das berchtige Winkelbyte:)
	byte MaxShipDirection; //Der maximale Wert. Der eigentliche Wert liegt also zwischen ShipDirection
						   //und MaxShipDirection (inklusive), wobei letzteres auch kleiner sein kann, wenn
	                       //die "Nahtstelle" des Rings dazwischen liegt. Es ist also auch
	                       //ShipDirection == 254 && MaxShipDirection == 2 mglich.
private:
	byte FireHyperspaceToggle; //Hier wird gespeichert, ob im letzten Frame geschossen wurde
	byte AccX, AccY; //Acc steht fr Acceleration. Die Variablen zeigen aber nicht wirklich
					 //die Beschleunigung, sondern stellen einen Timer fr jede Komponente dar.
	                 //Bei jedem Durchlauf wird die Geschwindigkeit gendert, je nachdem, ob
	                 //man gerade Gas gibt oder nicht.
	                 //Habs einfach so genannt, weil ich beim Lesen des Maschinencodes noch
	                 //nicht wusste, was sie genau bedeuten..
	byte NumAsteroids, NumAsteroidsStart;
public:
	byte SaucerCountdown, SaucerCountdownStart;	
	byte AsteroidDestroyedTimer; //Wird zurckgesetzt, wenn ein Asteroid getroffen wurde und zhlt
								 //stndig runter. Wird benutzt, um zu entscheiden, ob ein UFO
								 //erstellt werden soll.
								 //Es wird am Anfang nicht auf einen Wert gesetzt, sodass es am Anfang
								 //unbekannt ist, es sollte sich aber automatisch synchronisieren,
								 //da die KI recht schnell einen Asteroiden treffen sollte.
	byte InvisibleTimer; //Das Schiff ist unsichtbar, solange != 0
	byte NewLevelStartCountdown;
	byte Level; //Wird jedes Level bis zu einem Maximalwert inkrementiert
public:
	Object Objects[NumObjects];
	bool TimerUnknownWhenPlayerShot[cPlayerShots];
public:
	//Setzt den Zustand genau fest. Sodass also die Positionen der Objekte genau sind,
	//der Randomseed bekannt u.s.w. Die Entscheidungen sind willkrlich, der Zustand
	//wird also wahrscheinlich nicht mehr synchron mit dem Emulator sein.
	void SetFixed()
	{
		assert(VRamCounter == 0);
		TimerBitsKnown = 7;
		if(RandomSeedDistribution.GetNumSetBits() != 1)
		{
			int Index = RandomSeedDistribution.GetFirstSetIndex();
			RandomSeedDistribution.ClearAll();
			RandomSeedDistribution.Set(Index, true);
		}
		MaxShipDirection = ShipDirection;
		for(int i = 0; i < NumObjects; i++)
			Objects[i].SetFixed();
		for(int i = 0; i < cPlayerShots; i++)
			TimerUnknownWhenPlayerShot[i] = false;
	}

	//Vereint zwei Zustnde, sodass this alle Mglichkeiten hat, die auch rhs hat.
	//Das funktioniert natrlich nur fr die Variablen, die "unscharf" sein knnen,
	//wie zum Beispiel der Randomseed oder der Timer.
	//Wir knnen aber sicher sein, dass Variablen wie zB der Score immer gleich sind,
	//weil diese direkt aus dem VRam ablesbar sind und deshalb die Spielzustnde,
	//die zB mit dem Score abweichen, nicht durch den Check des VRams kommen.
	//Es werden also nur Spiele vereint, die den gleichen VRam Output haben.
	void operator |=(const GameRam& rhs)
	{
		assert( CurrentTime == rhs.CurrentTime &&
			    VRamCounter == rhs.VRamCounter &&
			    NumPlayers == rhs.NumPlayers &&
				Score == rhs.Score &&
				NumShips == rhs.NumShips &&
				HyperSpaceStatus == rhs.HyperSpaceStatus &&
//				Timer == rhs.Timer &&
//				TimerBitsKnown == rhs.TimerBitsKnown &&
//				RandomSeed1 == rhs.RandomSeed1 &&
//				RandomSeed2 == rhs.RandomSeed2 &&
//				ShipDirection == rhs.ShipDirection &&
				FireHyperspaceToggle == rhs.FireHyperspaceToggle &&
				AccX == rhs.AccX &&
				AccY == rhs.AccY &&
				NumAsteroids == rhs.NumAsteroids &&
				NumAsteroidsStart == rhs.NumAsteroidsStart &&
				SaucerCountdown == rhs.SaucerCountdown &&
				SaucerCountdownStart == rhs.SaucerCountdownStart &&
				AsteroidDestroyedTimer == rhs.AsteroidDestroyedTimer &&
				InvisibleTimer == rhs.InvisibleTimer &&
				NewLevelStartCountdown == rhs.NewLevelStartCountdown &&
				Level == rhs.Level);

		//Zwei Bereiche in einem Ring zu vereinen ist echt schwierig. Ich hoffe mal, dass das hier immer funktioniert:
		byte Min1 = Min(ShipDirection, rhs.ShipDirection);
		byte Max1 = Max(MaxShipDirection, rhs.MaxShipDirection);
		byte Min2 = Min(ShipDirection+128, rhs.ShipDirection+128);
		byte Max2 = Max(MaxShipDirection+128, rhs.MaxShipDirection+128);
		if(Max1 - Min1 < Max2 - Min2)
		{
			ShipDirection = Min1;
			MaxShipDirection = Max1;
		}
		else
		{
			ShipDirection = Min2-128;
			MaxShipDirection = Max2-128;
		}

		TimerBitsKnown = Min(TimerBitsKnown, rhs.TimerBitsKnown);

		while(byte(Timer << (8-TimerBitsKnown)) != byte(rhs.Timer << (8-TimerBitsKnown)))
			TimerBitsKnown--;

		RandomSeedDistribution |= rhs.RandomSeedDistribution;

		for(int i = 0; i < NumObjects; i++)
		{
			if(i >= AsteroidMinIndex && i <= AsteroidMaxIndex)
			{
				assert((Objects[i].Status&7) == (rhs.Objects[i].Status&7));
				//Es kann vorkommen, dass bei einer Asteroidenexplosion bei verschiedenen
				//Seeds die fast gleichen kleinen Asteroiden herauskommen, diese aber unterschiedliche
				//Anzeigetypen haben. Wir markieren den Fall einfach im 7. Bit (unbenutzt).
				if(Objects[i].Status>>3 != rhs.Objects[i].Status>>3)
					Objects[i].Status |= 0x40;
			}
			else
				assert(Objects[i].Status == rhs.Objects[i].Status);
			if(Objects[i].Status == 0)
				continue;
			for(int j = 0; j < rhs.Objects[i].cX; j++)
				Objects[i].AddLocationX(rhs.Objects[i].PX[j], rhs.Objects[i].VX[j]);
			for(int j = 0; j < rhs.Objects[i].cY; j++)
				Objects[i].AddLocationY(rhs.Objects[i].PY[j], rhs.Objects[i].VY[j]);
		}
	}

	static int GetRandomSeedIndex(byte RandomSeed1, byte RandomSeed2)
	{
		for(int i = 0; i < NumSeedCombinations; i++)
			if(RandomSeeds[i][0] == RandomSeed1 && RandomSeeds[i][1] == RandomSeed2)
			{
				return i;
			}
		assert(0);
		return 0;
	}


	void StartNewGame()//loc_68DE
	{
		memset(this, 0, sizeof(*this));//Bitte nicht nachmachen! Endet schnell bse, wenn Member C++ Objekte sind, virtuelle Methoden vorhanden sind oder Vererbung im Spiel ist.
		NumPlayers = 0;
		NumShips = 3;
//		RandomSeed1 = 5;
		NumAsteroidsStart = 2;
		InvisibleTimer = 1;
		SaucerCountdownStart = SaucerCountdown = 0x92;
		NewLevelStartCountdown = 0x7F;
		Level = 5;
		ResetPlayerPosition();

		VRamCounter = 0;
#ifdef DETECT_START_FOR_TIMERBITS
		StartSwapNoticed = false;
#endif
		RandomSeedDistribution.SetAll();
		TimerBitsKnown = 0;
		ShipDirection = 0;
		MaxShipDirection = 255;
	}

	bool NextObject_(int& Object, int MinIndex, int MaxIndex, bool& VRamInvalid)
	{
		for(Object--; Object >= MinIndex; Object--)
		{
			if(Objects[Object].Status)
			{
				if(Object > MaxIndex)
				{
					VRamInvalid = true;
					return true;
				}
				return false;
			}
		}
		VRamInvalid = true;
		return true;
	}
#define NextObject(a, b, c) do{ if(NextObject_(a, b, c, VRamInvalid)) return true; }while(false)

	bool CheckVRam(int& VRamScore, int& VRamNumShips, const word* VRam, bool& VRamInvalid)
	{
		assert(!VRamInvalid);
		VRamScore = 0;
		VRamNumShips = 0;

		VRamAssert(VRam[0] == 0xe001 || VRam[0] == 0xe201, VRamInvalid);

		//Wir zhlen, wie oft eine Zahl gezeichnet wird
		bool NumberRead = false;
		int Number = 0;
		int CountNumbers = 0;

		int vx, vy, vs;//Wo sich der Strahl gerade befindet und welche Skalierung eingestellt ist

		int v1x = 0, v1y = 0;
		int shipdetect = 0;

		int Object = NumObjects;

		//Ob wir im Men sind und nicht steuern knnen
		bool Preparing = false;

#ifdef DETECT_START_FOR_TIMERBITS
		//Wir prfen, ob Start angezeigt wird
		int StartCounter = 0;
		bool StartPrinted = false;
#endif

		if(NumPlayers == 0)
		{
			Object = AsteroidMaxIndex+1;
			VRamCounter = 1;

			for(int i = 0; i < NumObjects; i++)
				Objects[i].Status = 0;
		}


		
		for(int pc = 1; pc < 512;)
		{
			int op = VRam[pc] >> 12;
			int AsteroidType = 0;
			switch(op)
			{
			case 0xa://LABS (Strahl positionieren)
				vy = VRam[pc] & 0x3ff;
				vx = VRam[pc+1] & 0x3ff;
				vs = VRam[pc+1] >> 12;
				if(NumberRead)
				{
					if(CountNumbers++ == 0)
						VRamScore = Number;
					Number = 0;
				}
				break;
			case 0xb://H (Programmende)
			case 0xd://RTSL
			case 0xe://JMPL
				pc = 512;//Schleife beenden
				break;
			case 0xc://JSRL (Subroutine aufrufen)
				switch(VRam[pc] & 0x0FFF)//Welche Adresse springen wir an?
				{
				case 0x880://Explosion
				case 0x896:
				case 0x8B5:
				case 0x8D0:
					if(NumPlayers)
					{
						if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0 &&
							!(Object > SaucerIndex && Objects[SaucerIndex].Status < 0))
							NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
						NextObject(Object, AsteroidMinIndex, SaucerIndex);
						VRamAssert(Objects[Object].Status < 0, VRamInvalid);
						if(Objects[Object].SetVRamLocation(vx, vy, VRamCounter, VRamInvalid))
							return true;
					}
					break;

				case 0x91a://Asteroide (4 Typen)
					AsteroidType++;
				case 0x90d:
					AsteroidType++;
				case 0x8ff:
					AsteroidType++;
				case 0x8f3:
					if(NumPlayers)
					{
						if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0)
							NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
						NextObject(Object, AsteroidMinIndex, AsteroidMaxIndex);
						if(vs == 0)//gro
							VRamAssert((Objects[Object].Status & 0x04) != 0, VRamInvalid);
						else if(vs == 15)//mittel
							VRamAssert((Objects[Object].Status & 0x02) != 0, VRamInvalid);
						else if(vs == 14)//klein
							VRamAssert((Objects[Object].Status & 0x01) != 0, VRamInvalid);
						else
							VRamAssert(0, VRamInvalid);
						VRamAssert(Objects[Object].Status>>3 == AsteroidType || (Objects[Object].Status&0x40) != 0, VRamInvalid);
						if(Objects[Object].SetVRamLocation(vx, vy, VRamCounter, VRamInvalid))
							return true;
					}
					else
					{
						Object--;
						VRamAssert(Object >= AsteroidMinIndex && Object <= AsteroidMaxIndex, VRamInvalid);
						if(vs == 0)//gro
							Objects[Object].Status = 0x04;
						else if(vs == 15)//mittel
							Objects[Object].Status = 0x02;
						else if(vs == 14)//klein
							Objects[Object].Status = 0x01;
						else
							VRamAssert(0, VRamInvalid);
						Objects[Object].Status |= AsteroidType<<3;
						if(Objects[Object].SetVRamLocation(vx, vy, VRamCounter, VRamInvalid))
							return true;
					}
					break;

				case 0x929://UFO
					if(NumPlayers)
					{
						NextObject(Object, SaucerIndex, SaucerIndex);
						if(vs == 15)//gro
							VRamAssert(Objects[Object].Status == 2, VRamInvalid);
						else if(vs == 14)//klein
							VRamAssert(Objects[Object].Status == 1, VRamInvalid);
						else
							VRamAssert(0, VRamInvalid);
						if(Objects[Object].SetVRamLocation(vx, vy, VRamCounter, VRamInvalid))
							return true;
					}
					break;

				case 0xa6d://Lebenanzeige
					VRamNumShips++;
					break;

				//Ziffern:
				case 0xadd: NumberRead = true; Number = Number*10 + 0; break;
				case 0xb2e: NumberRead = true; Number = Number*10 + 1; break;
				case 0xb32: NumberRead = true; Number = Number*10 + 2; break;
				case 0xb3a: NumberRead = true; Number = Number*10 + 3; break;
				case 0xb41: NumberRead = true; Number = Number*10 + 4; break;
				case 0xb48: NumberRead = true; Number = Number*10 + 5; break;
				case 0xb4f: NumberRead = true; Number = Number*10 + 6; break;
				case 0xb56: NumberRead = true; Number = Number*10 + 7; break;
				case 0xb5b: NumberRead = true; Number = Number*10 + 8; break;
				case 0xb63: NumberRead = true; Number = Number*10 + 9; break;

				//Buchstabe 'E' abfangen. Es wird wahrscheinlich "Spieler", "Player", "Game Over" o.. angezeigt. Jedenfalls knnen wir nicht steuern
				case 0xA9B:
#ifdef DETECT_START_FOR_TIMERBITS
					StartCounter = 0;
#endif
					Preparing = true;
					break;
				
#ifdef DETECT_START_FOR_TIMERBITS
				//"START" aus zB "PUSH START" abfangen. (Kommt in allen Sprachen vor). Da die Anzeige synchron
				//mit dem Timer blinkt, knnen wir herausfinden, wie dieser intern ist.
				case 0xAFB: /*S*/ StartCounter = 1; break;
				case 0xB02: /*T*/ if(StartCounter == 1) StartCounter++; else if(StartCounter == 4) StartPrinted = true; else StartCounter = 0; break;
				case 0xA78: /*A*/ if(StartCounter == 2) StartCounter++; else StartCounter = 0; break;
				case 0xAF3: /*R*/ if(StartCounter == 3) StartCounter++; else StartCounter = 0; break;


				//Alle anderen Buchstaben
				case 0xA80://B
				case 0xA8D://C
				case 0xA93://D
				case 0xAA3://F
				case 0xAAA://G
				case 0xAB3://H
				case 0xABA://I
				case 0xAC1://J
				case 0xAC7://K
				case 0xACD://L
				case 0xAD2://M
				case 0xAD8://N
				//O wird durch 0 angezeigt
				case 0xAE3://P
				case 0xAEA://Q
				case 0xB08://U
				case 0xB0e://V
				case 0xB13://W
				case 0xB1a://X
				case 0xB1f://Y
				case 0xB26://Z
					StartCounter = 0;
					break;
#endif
				}
				break;
			default:
			{
				int dy = VRam[pc] & 0x3ff;
				if(VRam[pc] & 0x400)
					dy = -dy;
				int dx = VRam[pc+1] & 0x3ff;
				if(VRam[pc+1] & 0x400)
					dx = -dx;
				//sf = VRam[pc] >> 12;
				int vz = VRam[pc+1] >> 12;

				//Schsse abfragen
				if(NumPlayers && dx == 0 && dy == 0 && vz == 15)
				{
					NextObject(Object, SaucerShotMinIndex, PlayerShotMaxIndex);
					if(Objects[Object].SetVRamLocation(vx, vy, VRamCounter, VRamInvalid))
						return true;
				}

				//Schiff
				if(op == 6 && vz == 12 && dx != 0 && dy != 0)
				{
					switch (shipdetect)
					{
					case 0:
						v1x = dx;
						v1y = dy;
						++shipdetect;
						break;
					case 1:
						if(NumPlayers)
						{
							NextObject(Object, PlayerIndex, PlayerIndex);
							VRamAssert(Objects[Object].Status == 1, VRamInvalid);
							if(Objects[Object].SetVRamLocation(vx, vy, 0, VRamInvalid))
								return true;
						}
						else
						{
							Objects[PlayerIndex].Status = 1;
							if(Objects[PlayerIndex].SetVRamLocation(vx, vy, VRamCounter, VRamInvalid))
								return true;
						}

						//Das Winkelbyte bestimmen
						int ship_dx = v1x - dx;
						int ship_dy = v1y - dy;
						if(ShipDirection == 0 && MaxShipDirection == 255)
						{
							//Die Richtung ist noch vllig unbekannt
							if(ship_dx == 1536 && ship_dy == 0)
							{
								//Diese Richtung braucht eine Extrabehandlung, weil der Max Index kleiner als der Min Index ist
								ShipDirection = 253;
								MaxShipDirection = 3;
							}
							else
							{
								ShipDirection = 255;
								MaxShipDirection = 0;
								for(int i = 0; i < 256; i++)
									if(VRamShipDirections[i][0] == ship_dx &&
										VRamShipDirections[i][1] == ship_dy)
									{
										ShipDirection = Min(ShipDirection, (byte)i);
										MaxShipDirection = Max(ShipDirection, (byte)i);
									}
							}
						}
						else
						{
							//Wir ziehen den Bereich immer weiter zu, bis wir den genauen Wert
							//kennen (ShipDirection==MaxShipDirection)
							while(VRamShipDirections[ShipDirection][0] != ship_dx || VRamShipDirections[ShipDirection][1] != ship_dy)
								ShipDirection++;
							while(VRamShipDirections[MaxShipDirection][0] != ship_dx || VRamShipDirections[MaxShipDirection][1] != ship_dy)
								MaxShipDirection--;
						}
						++shipdetect;
						break;
					}
				}
				else if(shipdetect == 1)
					shipdetect = 0;
				break;
			}
			}
			if(op <= 0xa)
				++pc;
			if(op != 0xe) // JMPL
				++pc;
		}
		if(NumPlayers)
		{
			//Alle anderen Objekte mssen auch bei uns weg sein:
			if(Object > PlayerIndex && Objects[PlayerIndex].Status < 0)
				NextObject(Object, PlayerIndex, PlayerIndex);//Die Schiffsexplosion fragen wir nicht ab (zu kompliziert und nutzlos)
			while(--Object >= 0)
				VRamAssert(Objects[Object].Status == 0, VRamInvalid);
		}
		else
		{
#ifdef DETECT_START_FOR_TIMERBITS
			if(TimerBitsKnown < 6 && StartPrinted && !StartPrintedLastFrame && CurrentTime)
			{
				if(StartSwapNoticed && (Timer&0x3F) == 0)
				{
					TimerBitsKnown = 6;
					printf("6 Timerbits\n");
				}
				else if((Timer&1) == 0)
				{
					Timer = 0;
					StartSwapNoticed = true;
				}
			}
			else if(TimerBitsKnown < 6 && !StartPrinted && StartPrintedLastFrame && CurrentTime)
			{
				if(StartSwapNoticed && (Timer&0x3F) == 0x20)
				{
					TimerBitsKnown = 6;
					printf("6 Timerbits\n");
				}
				else if((Timer&1) == 0)
				{
					Timer = 0x20;
					StartSwapNoticed = true;
				}
			}
			else
#endif
			if(TimerBitsKnown < 1)
			{
				//Das erste Byte zeigt auf den aktuellen Vektorpuffer, welcher jeden Frame synchron mit dem Timer wechselt.
				//Wir wissen also wenigstens, ob der Timer gerade oder ungerade ist.
				Timer = VRam[0] == 0xe001 ? 0 : 1;
				TimerBitsKnown = 1;
			}
		}
#ifdef DETECT_START_FOR_TIMERBITS
		StartPrintedLastFrame = StartPrinted;
#endif
		//printf("Zahlen: %i\n", CountNumbers);
		if(CountNumbers == 3 || Preparing)
			return false;
		if(NumPlayers == 0)
		{
			printf("Starte neues Spiel! Timer: %i\n", Timer&3);
			GameStartedTime = CurrentTime;
			NumPlayers = 1;
			NumAsteroids = AsteroidMaxIndex+1-Object;
			NumAsteroidsStart = 4;
			InvisibleTimer = 0;
			SaucerCountdownStart = 0x92;
			SaucerCountdown = 0x7f;
			NewLevelStartCountdown = 0;
			Level = 6;
			ResetPlayerPosition();
			if(TimerBitsKnown < 2)
			{
				//Der Timer muss genau diese Werte haben. kA warum...
				Timer = Timer%2 == 0 ? 2 : 1;
			}
			else if((Timer&3) == 0)
				SaucerCountdown--;

			//ResetSaucerCountdown(0x7f);

			//Die Position des UFOs ist nicht bekannt und wird spter, wenn es erscheint,
			//nicht vollstndig gesetzt
			for(int p = 0; p < 32; p++)
			for(int v = -16; v <= 16; v += 16)
			{
				Objects[SaucerIndex].PY[Objects[SaucerIndex].cY] = p << 3;
				Objects[SaucerIndex].VY[Objects[SaucerIndex].cY] = v;
				Objects[SaucerIndex].cY++;
			}
			//Die leeren Asteroidslots sind natrlich auch nicht bekannt und werden
			//bei neuen Levels leider auch nicht komplett gesetzt
			//(Das untere Byte einer zuflligen Positionskomponente bleibt ungesetzt)
			for(int i = AsteroidMinIndex; i <= AsteroidMaxIndex; i++)
			{
				if(Objects[i].Status)
					continue;
				for(int j = 0; j < 256; j++)
				{
					Objects[i].PX[j] = j;
					Objects[i].PY[j] = j;
				}
				Objects[i].cX = Objects[i].cY = 256;
			}

			//Wenn wir den Timer nicht genau kennen, knnen wir nicht genau sagen
			//wie lange ein Spielerschuss berlebt.
			for(int i = 0; i < cPlayerShots; i++)
				TimerUnknownWhenPlayerShot[i] = false;


			//VRamAssert(Object == AsteroidMaxIndex+1-4);////////////////////////
/*			for(int i = 0; i < _countof(AsteroidStartPositions); i++)
			{
				::Object CorrectAsteroids[4];
				int j = 0;
				for(; j < 4; j++)
				{
					if(Objects[j+1+AsteroidMaxIndex-4].PositionX/8 >= AsteroidStartPositions[i].Asteroids[j].MinComponent && Objects[j+1+AsteroidMaxIndex-4].PositionX/8 <= AsteroidStartPositions[i].Asteroids[j].MaxComponent &&
					   AsteroidStartPositions[i].Asteroids[j].ExactComponent/8 == Objects[j+1+AsteroidMaxIndex-4].PositionY/8)
					{
						CorrectAsteroids[j].Status = Objects[j+1+AsteroidMaxIndex-4].Status;
						CorrectAsteroids[j].PositionX = Objects[j+1+AsteroidMaxIndex-4].PositionX;
						CorrectAsteroids[j].PositionY = AsteroidStartPositions[i].Asteroids[j].ExactComponent;
						CorrectAsteroids[j].VelocityX = AsteroidStartPositions[i].Asteroids[j].VelocityX;
						CorrectAsteroids[j].VelocityY = AsteroidStartPositions[i].Asteroids[j].VelocityY;
					}
					else if(Objects[j+1+AsteroidMaxIndex-4].PositionY/8 >= AsteroidStartPositions[i].Asteroids[j].MinComponent && Objects[j+1+AsteroidMaxIndex-4].PositionY/8 <= AsteroidStartPositions[i].Asteroids[j].MaxComponent &&
					        AsteroidStartPositions[i].Asteroids[j].ExactComponent/8 == Objects[j+1+AsteroidMaxIndex-4].PositionX/8)
					{
						CorrectAsteroids[j].Status = Objects[j+1+AsteroidMaxIndex-4].Status;
						CorrectAsteroids[j].PositionX = AsteroidStartPositions[i].Asteroids[j].ExactComponent;
						CorrectAsteroids[j].PositionY = Objects[j+1+AsteroidMaxIndex-4].PositionY;
						CorrectAsteroids[j].VelocityX = AsteroidStartPositions[i].Asteroids[j].VelocityX;
						CorrectAsteroids[j].VelocityY = AsteroidStartPositions[i].Asteroids[j].VelocityY;
					}
					else
						break;
				}
				if(j == 4)
					printf("Seed gefunden! %x %x\n", AsteroidStartPositions[i].s1, AsteroidStartPositions[i].s2);
			}
			MessageBeep(0);*/
		}
		if(VRamCounter && ++VRamCounter == 4)
			VRamCounter = 0;
		return true;

	}


	void CalculateNextShot(const ShotInfoList& ShotInfos, int MinShootTime, std::multiset<ShotInfoList>& ShotInfosVariety) const;
	void CalculateNextShot_(const ShotInfoList& ShotInfos, int MinShootTime, std::multiset<ShotInfoList>& ShotInfosVariety);
//	void CalculateNextShot(std::vector<ShotInfo>& ShotInfos, int& MaxCollisionTime, int MinShootTime);
	void SimulateShot(ObjectsStateList& ObjectsStates, const ShotInfoList& ShotInfos, const int CurrentObjectsStates, const int CurrentShotInfo, const int cShotsShot, const int t, const int ShotIndex, const int DeltaDir, int& MinCollisionAtTime, std::multiset<ShotInfoList>& ShotInfosVariety, bool RotationWasLocked);
	void CheckForErrors(const ShotInfoList& ShotInfos, int UntilTime);

	int GetCountExtraSlots() const
	{
		int CountExtraSlots = 0;
		for(int i = PlayerShotMinIndex; i <= PlayerShotMaxIndex; i++)
			if(Objects[i].Status == 0)
				CountExtraSlots++;
		return CountExtraSlots;
	}

	void ResetSaucerCountdown(byte NewValue)
	{
		SaucerCountdown = NewValue;
		//Wenn wir den Countdown ndern mssen wir u.U. den Timer anpassen, da wir davon ausgehen,
		//dass unser Saucercountdown immer grer oder gleich dem echten Saucercountdown ist.
		if(TimerBitsKnown < 2 && ((Timer&3) == 2 || (Timer&3) == 3))
			Timer += 2;
	}

	void Render(HDC hdcScreen, int cx, int cy);
	void CheckRam(const byte* Ram) const
	{
		assert(RandomSeedDistribution.Get(GetRandomSeedIndex(Ram[0x5F], Ram[0x60])));

		/*static std::map<byte, std::pair<int, int>> ShipDirections;

		if(NumPlayers)
		{
			if(ShipDirections.find(Ram[0x61]) != ShipDirections.end())
				VRamAssert(ShipDirections[Ram[0x61]] == std::pair<int, int>(ship_dx, ship_dy));
			else
				ShipDirections[Ram[0x61]] = std::pair<int, int>(ship_dx, ship_dy);
			printf("ShipDirs: %i\n", ShipDirections.size());
			if(ShipDirections.size() == 256)
			{
				FILE* out = fopen("ShipDirections.txt", "w");
				for(int i = 0; i < 256; i++)
					fprintf(out, "\t{%i, %i},\n", ShipDirections[i].first, ShipDirections[i].second);
				fclose(out);
			}
		}*/

		//LowByte(Objects[SaucerIndex].PositionY) = Ram[0x2d2+0x1c];
		
		//RandomSeed1 = Ram[0x5F];
		//RandomSeed2 = Ram[0x60];
/*		if(VRamCounter)
		{
			SaucerCountdown = Ram[0x02F7];
			_2F9 = Ram[0x02F9];
		}*/
		//SaucerCountdownStart = Ram[0x02F8];
//		Timer = Ram[0x5C];
		//Level = Ram[0x02FD];

		byte i = ShipDirection;
		while(i != Ram[0x61])
		{
			if(i++ == MaxShipDirection)
				assert(0);
		}

		assert(byte(Timer << (8-TimerBitsKnown)) == byte(Ram[0x5C] << (8-TimerBitsKnown)));

		if(VRamCounter || !NumPlayers)
			return;

		assert(SaucerCountdown == Ram[0x02F7] ||
			   ((SaucerCountdown==1?0x12:SaucerCountdown-1) == Ram[0x02F7] && TimerBitsKnown < 2));

//		if(RandomSeed1 != Ram[0x5F] || RandomSeed2 != Ram[0x60])
//			return false;
		//return;
		
		/*FILE* out = fopen("Seeds.txt", "w");
		byte s1 = RandomSeed1;
		byte s2 = RandomSeed2;
		Rand();
		int i = 0;
		while(s1 != RandomSeed1 || s2 != RandomSeed2)
		{
			fprintf(out, "\t{0x%02x, 0x%02x},\n", RandomSeed1, RandomSeed2);
			Rand();
		}
		fprintf(out, "\t{0x%02x, 0x%02x},\n", RandomSeed1, RandomSeed2);
		fclose(out);
		exit(0);*/

		assert(Score%100000 == DecimalToBin(Ram[0x53], Ram[0x52])*10);

		struct
		{
			const byte* pVariable;
			int Address;
		}
		VariableAddresses[] =
		{
			&NumPlayers,			   0x1C,
			//&NumShips,				   0x57,
			(byte*)&HyperSpaceStatus,  0x59,
			//&FireHyperspaceToggle,	   0x63,
			//&AccX,					   0x64,
			//&AccY,					   0x65,
			&NumAsteroidsStart,        0x02F5,
			&NumAsteroids,			   0x02F6,
			&SaucerCountdownStart,	   0x02F8,
			//&AsteroidDestroyedTimer,   0x02F9,
			&InvisibleTimer,		   0x02FA,
			&NewLevelStartCountdown,   0x02FB,
			&Level,                    0x02FD
		};


		for(int i = 0; i < _countof(VariableAddresses); i++)
			assert(*VariableAddresses[i].pVariable == Ram[VariableAddresses[i].Address]);


		for(int i = 0; i < NumObjects; i++)
		{
			if(i >= SaucerShotMinIndex && i <= PlayerShotMaxIndex)
				assert((Objects[i].Status+3)/4 == char(Ram[0x200+i]) ||
				i >= PlayerShotMinIndex && (Objects[i].Status+3)/4 == char(Ram[0x200+i]+1) && TimerUnknownWhenPlayerShot[i-PlayerShotMinIndex]);
			else if(i >= AsteroidMinIndex && i <= AsteroidMaxIndex)
				assert((Objects[i].Status&~0x40) == char(Ram[0x200+i]) || (Objects[i].Status&0x40) != 0);
			else
				assert(Objects[i].Status == char(Ram[0x200+i]));
			if(Objects[i].Status)
				Objects[i].ValidatePosition(MakeWord(Ram[0x269+i], Ram[0x2AF+i]), MakeWord(Ram[0x28C+i], Ram[0x2D2+i]),
											char(Ram[0x223+i]), char(Ram[0x246+i]));
		}

		/*if(errors)
		{
			sockaddr_in server;
			memset(&server, 0, sizeof server);
			server.sin_family = AF_INET;
			server.sin_port = htons(1979);
			server.sin_addr.s_addr = server_ip;
			sendto(sd, "stop", 5, 0, (sockaddr*)&server, sizeof server);
		}*/


/*		while(errors)
		{
			*this = last_ram;
			Move_(keys, ShotInfo, ram, 0, 0);
		}*/
	}

	byte GetKeyFromShotInfo(const ShotInfo& CurrentShotInfo, const ShotInfo& NextShotInfo)
	{
		byte Keys = 0;
		assert(CurrentShotInfo.Time >= CurrentTime);
		if(CurrentShotInfo.Time != MaxInt && ShipDirection != CurrentShotInfo.TargetDirection)
		{
			Keys = KeyFromDirection(CurrentShotInfo.Dir);
		}
		if(CurrentShotInfo.Time <= CurrentTime)
		{
			//Jetzt mssen wir schieen
			if(ValidateKIGame)
				assert(ShipDirection == CurrentShotInfo.TargetDirection, KIGameInvalidException());
			assert(NextShotInfo.Time > CurrentTime);
			//Jetzt schon die Richtung fr den nchsten Schuss setzen, da Asteroids leider erst schiet und dann die Richtung ndert
			if(NextShotInfo.Time != MaxInt && ShipDirection != NextShotInfo.TargetDirection)
				Keys = KeyFromDirection(NextShotInfo.Dir);
			else
				Keys = 0;
			Keys |= Key_Fire;
		}
		return Keys;
	}

	void Move(const ShotInfo& CurrentShotInfo, const ShotInfo& NextShotInfo)
	{
		Move(GetKeyFromShotInfo(CurrentShotInfo, NextShotInfo));
	}

	void VRamMove(byte Keys, byte NextKeys, const word* VRam, const word* NextVRam, bool& VRamInvalid)
	{
#if 0
		FILE* out = fopen("blabla.txt", "w");
	
		byte s1 = 0, s2 = 0;

		std::set<int> seeds;
		RandomSeed1 = s1;
		RandomSeed2 = s2;
		int h = 0;
		do
		{
			NumAsteroidsStart = 2;
			Objects[SaucerIndex].Status = 0;
			NewLevelStartCountdown = 0;
			ResetAsteroids();
			fprintf(out, "\t{ 0x%02x, 0x%02x, 0x%02x, 0x%02x, { ", s1, s2, RandomSeed1, RandomSeed2);
			for(int i = AsteroidMaxIndex-4+1; i <= AsteroidMaxIndex; i++)
			{
				if(Objects[i].PositionY == 0)
				{
					VRamAssert(Objects[i].PositionX != 0);
					LowByte(Objects[i].PositionX) = 0;
					word MinX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1)/8;
					LowByte(Objects[i].PositionX) = 0xff;
					word MaxX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1)/8;
					Objects[i].PositionY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1);
					fprintf(out, "{ 0x%04x, 0x%04x, 0x%04x, (char)0x%02x, (char)0x%02x}, ",
						MinX, MaxX, Objects[i].PositionY,
						Objects[i].VelocityX&0xff, Objects[i].VelocityY&0xff);
				}
				else if(Objects[i].PositionX == 0)
				{
					LowByte(Objects[i].PositionY) = 0;
					word MinY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1)/8;
					LowByte(Objects[i].PositionY) = 0xff;
					word MaxY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1)/8;
					Objects[i].PositionX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1);
					fprintf(out, "{ 0x%04x, 0x%04x, 0x%04x, (char)0x%02x, (char)0x%02x}, ",
						MinY, MaxY, Objects[i].PositionX,
						Objects[i].VelocityX&0xff, Objects[i].VelocityY&0xff);
				}
				else
					VRamAssert(0);
				//PreMoveObject(i);
			}
			fprintf(out, "} },\n");
			RandomSeed1 = s1;
			RandomSeed2 = s2;
			Rand();
			s1 = RandomSeed1;
			s2 = RandomSeed2;
			printf("%i\n", h++);
			if(seeds.find(MakeWord(s1,s2)) != seeds.end())
				break;
			seeds.insert(MakeWord(s1,s2));
		}while(RandomSeed1 || RandomSeed2);
		fclose(out);
		exit(0);
#endif

		assert(!VRamInvalid);
		std::stack<MovePosition<GameRam>> MovePositions;
		std::vector<GameRam> OredGames;
		MovePosition<GameRam> NextMovePosition(MPT_Start, false);

		while(true)
		{
			VRamInvalid = false;

			int VRamScore, VRamNumShips;
			if(!VRamMove(Keys, VRam, NextVRam == 0, NextMovePosition, MovePositions, VRamScore, VRamNumShips, VRamInvalid))
				return;
			if(!VRamInvalid)
			{
				assert(NextVRam != 0);
				GameRam(*this).VRamMove(NextKeys, 0, NextVRam, 0, VRamInvalid);
			}
			if(VRamInvalid)
			{
				if(MovePositions.empty() && NextVRam == 0)
					return;//An das uere VRamMove abgeben
				if(MovePositions.empty() && NextVRam && OredGames.empty())
				{
					assert(0);
				}
			}

			while(!VRamInvalid && !MovePositions.empty() && MovePositions.top().SkipRemainingIfSuccessful)
				MovePositions.pop();

			if(MovePositions.empty())
			{
				assert(NextVRam != 0);
				break;
			}

			if(!VRamInvalid && NextVRam)
				OredGames.push_back(*this);

			NextMovePosition = MovePositions.top();
			MovePositions.pop();
			*this = NextMovePosition.Game;
		}
		assert(NextVRam != 0);

		size_t i = 0;
		if(VRamInvalid)
		{
			assert(!OredGames.empty());
			*this = OredGames[0];
			i = 1;
		}
		for(; i < OredGames.size(); i++)
			*this |= OredGames[i];
		if(OredGames.size())
			RandomSeedDistribution.UpdateInternalData();
	}

	bool VRamMove(byte Keys,
				  const word* VRam,
				  bool InnerMove,
				  const MovePosition<GameRam>& NextMovePosition,
				  std::stack<MovePosition<GameRam>>& MovePositions,
				  int& VRamScore, int& VRamNumShips, bool& VRamInvalid)
	{
		ShotInfo ShotInfo;
		int CollisionObject;
		int FixedTarget;

		//Ja, ich wei. goto ist bse. Es wre hier auch viel einfacher, wenn man den Stack kopieren und wiederherstellen
		//knnte. Leider wei ich nicht wie das geht und bezweifle auch, dass es einfach ist.
		//Unter Unix knnte man einfach fork() benutzen. Allerdings wei ich nicht, ob das so schnell wre und
		//mag Windows einfach lieber:)
		//Jedenfalls ist das mit den gotos zwar etwas unbersichtlich, aber sicher bersichtlicher als wenn ich
		//hier paar Ebenen mit if else Blcken reingepackt htte, oder das ganze mit ner Statemachine gemacht htte.
		switch(NextMovePosition.Type)
		{
		case MPT_Start:
			break;

		case MPT_Shoot:
			goto ShootLabel;

		case MPT_UpdateSaucer:
			goto UpdateSaucerLabel;

		case MPT_UpdateShots:
			goto UpdateShotsLabel;

		case MPT_ObjectCollision:
			CollisionObject = NextMovePosition.CollisionCauser;
			FixedTarget = NextMovePosition.Target;
			goto CheckCollisionsLabel;

		case MPT_ResetAsteroids:
			goto ResetAsteroidsLabel;

		default:
			assert(0);
		}

		//sub_6885
		if(NumPlayers &&
			Objects[PlayerIndex].Status == 0 &&
			InvisibleTimer == 0x80)
		{
			InvisibleTimer = 0x10;
			//if(cShips == 0) loc_69CF();
			//sub_702D
			ResetSaucerCountdown(SaucerCountdownStart);
			Objects[SaucerIndex].Status = 0;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
		}
		Timer++;

ShootLabel:
		Shoot(Keys, &MovePositions);
		DoHyperSpace(Keys);
		UpdateHyperspace(Keys); //Ruft UpdateDirectionAndThrust() auf
UpdateSaucerLabel:
		if(!UpdateSaucer(&MovePositions, InnerMove))
			return false;

		//Objekte aktualisieren
		if(!VRamCounter)
			for(int i = NumObjects-1; i >= 0; i--)
				MoveObject(i);

		if(!CheckVRam(VRamScore, VRamNumShips, VRam, VRamInvalid))
		{
			CurrentTime++;
			return false;
		}
		if(VRamInvalid)
			return true;
		if(InnerMove)
			return false;

UpdateShotsLabel:
		UpdateShots(&MovePositions);

		// Kollision fr Spielerschsse(4), Saucerschsse(2), Saucer und Schiff prfen
		CollisionObject = PlayerShotMaxIndex;
		FixedTarget = -1;
CheckCollisionsLabel:
		for(; CollisionObject >= PlayerIndex; CollisionObject--)
		{
			CheckCollisions(CollisionObject, FixedTarget, &MovePositions);
			FixedTarget = -1;
		}

		VRamAssert(Score%100000 == VRamScore, VRamInvalid);
		VRamAssert(NumShips == VRamNumShips, VRamInvalid);

		//Asteroids ruft hier Rand() auf. Aufgrund der Weise, wie wir uns die Verteilung
		//speichern, knnen wir die Verteilung einfach nach rechts rotieren.
		//Siehe auch RandomSeeds.h
		RandomSeedDistribution.RotateRight();

		//sub_7BC0

		byte a = NewLevelStartCountdown;
		if(a)
			NewLevelStartCountdown--;
		if((a | NumAsteroids) == 0)
		{
ResetAsteroidsLabel:
			ResetAsteroids(&MovePositions);
		}

		CurrentTime++;
		return true;
	}

	void UpdateShots(std::stack<MovePosition<GameRam>>* pMovePositions)
	{
//		if(Timer & 3)
//			return;
		for(int i = PlayerShotMinIndex; i <= PlayerShotMaxIndex; i++)
		{
			if(Objects[i].Status == 3 && TimerUnknownWhenPlayerShot[i-PlayerShotMinIndex])
			{
				//Der Schuss knnte gleich schon weg sein, wenn unser Timer falsch ist
				TimerUnknownWhenPlayerShot[i-PlayerShotMinIndex] = false;
				MovePosition<GameRam> NewMovePosition(MPT_UpdateShots, true);
				NewMovePosition.Game = *this;
				NewMovePosition.Game.Objects[i].Status = 1;
				pMovePositions->push(NewMovePosition);
			}
		}
		for(int i = PlayerShotMaxIndex; i >= SaucerShotMinIndex; i--)
		{
			if(Objects[i].Status > 0)
			{
				Objects[i].Status--;
				if(Objects[i].Status == 0 && i >= PlayerShotMinIndex)
				{
#ifdef PRINT_DEBUG_INFO
					printf("Shot %i ins Leere gegangen um %i\n", i-PlayerShotMinIndex, CurrentTime);
#endif
					if(ValidateKIGame)
						assert(0, KIGameInvalidException());
					//*pErrorsOccured = true;
				}
			}
		}
	}

	void Move(byte Keys)
	{
		assert(VRamCounter == 0);

		//sub_6885
		if(NumPlayers &&
			Objects[PlayerIndex].Status == 0 &&
			InvisibleTimer == 0x80)
		{
			InvisibleTimer = 0x10;
			//if(cShips == 0) loc_69CF();
			//sub_702D
			ResetSaucerCountdown(SaucerCountdownStart);
			Objects[SaucerIndex].Status = 0;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
		}

		Timer++;

		Shoot(Keys, 0);
		DoHyperSpace(Keys);
		UpdateHyperspace(Keys); //Ruft UpdateDirectionAndThrust() auf
		UpdateSaucer(0, false);

		//Objekte aktualisieren
		for(int i = NumObjects-1; i >= 0; i--)
			MoveObject(i);

		UpdateShots(0);

		// Kollision fr Spielerschsse(4), Saucerschsse(2), Saucer und Schiff prfen
		for(int CollisionObject = PlayerShotMaxIndex; CollisionObject >= PlayerIndex; CollisionObject--)
			CheckCollisions(CollisionObject, -1, 0);

		//Asteroids ruft hier Rand() auf. Aufgrund der Weise, wie wir uns die Verteilung
		//speichern, knnen wir die Verteilung einfach nach rechts rotieren.
		//Siehe auch RandomSeeds.h
		RandomSeedDistribution.RotateRight();

		//sub_7BC0

		byte a = NewLevelStartCountdown;
		if(a)
			NewLevelStartCountdown--;
		if((a | NumAsteroids) == 0)
			ResetAsteroids(0);

		CurrentTime++;
	}

	byte GetHash()
	{
		return Timer&0x3F;
/*		byte h = RandomSeed1 + RandomSeed2;
		for(int i = 0; i < NumObjects; i++)
		{
			h += Objects[i].Status;
			h += Objects[i].VelocityX + Objects[i].VelocityY;
			h += LowByte(Objects[i].PositionX) + HighByte(Objects[i].PositionX);
			h += LowByte(Objects[i].PositionY) + HighByte(Objects[i].PositionY);
		}
		return h;*/
	}

	void Shoot(byte Keys, std::stack<MovePosition<GameRam>>* pMovePositions)//sub_6CD7
	{
		if(NumPlayers == 0)
			return;

		if(ShipDirection != MaxShipDirection &&
			(Keys & Key_Fire) &&
			(FireHyperspaceToggle & 0x80) == 0 &&
			InvisibleTimer == 0 &&
			GetCountExtraSlots())
		{
			//Wir werden gleich schieen, kennen die Schiffsrichtung aber noch nicht genau
			MovePosition<GameRam> NewMovePosition(MPT_Shoot, false);
			NewMovePosition.Game = *this;
			NewMovePosition.Game.ShipDirection++;
			pMovePositions->push(NewMovePosition);

			MaxShipDirection = ShipDirection;
		}

		FireHyperspaceToggle >>= 1;
		if(Keys & Key_Fire)
			FireHyperspaceToggle |= 0x80;

		if(!(Keys & Key_Fire) || //nicht gedrckt?
			FireHyperspaceToggle & 0x40 || //letzten Frame schon gedrckt?
			InvisibleTimer) //unsichtbar?
			return;

		int NewShot = PlayerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == PlayerShotMinIndex)
				return;

		Objects[NewShot] = Objects[PlayerIndex];
		//Objects[NewShot].Status = ShotLifetime/4;

		if(TimerBitsKnown >= 2)
		{
			if((Timer&3) == 0)
				Objects[NewShot].Status = ShotLifetime-3;
			else if((Timer&3) == 1)
				Objects[NewShot].Status = ShotLifetime;
			else if((Timer&3) == 2)
				Objects[NewShot].Status = ShotLifetime-1;
			else if((Timer&3) == 3)
				Objects[NewShot].Status = ShotLifetime-2;
		}
		else
		{
			assert(TimerBitsKnown == 1);
			if(Timer & 1)
				Objects[NewShot].Status = ShotLifetime;
			else
				Objects[NewShot].Status = ShotLifetime-1;
		}


		TimerUnknownWhenPlayerShot[NewShot-PlayerShotMinIndex] = TimerBitsKnown < 2;

		ShootLocationFromAngle(ShipDirection, Objects[NewShot].PositionX, Objects[NewShot].PositionY, Objects[NewShot].VelocityX, Objects[NewShot].VelocityY);
	}

	static void ShootLocationFromAngle(byte Direction, word& PositionX, word& PositionY, char& VelocityX, char& VelocityY)
	{
		//xVelocity
		byte a = Direction;
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += byte(VelocityX);
		Clamp(a, 0x91, 0x6F);
		VelocityX = char(a);

		//yVelocity
		a = Direction;
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += byte(VelocityY);
		Clamp(a, 0x91, 0x6F);
		VelocityY = char(a);

		PositionX += char(tmp9) + char(Half(tmp9));
		PositionY += char(tmpC) + char(Half(tmpC));

/*		//xVelocity
		byte a = Var(RAM_ShipDirection);
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += VarO(RAMO_VelocityX, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityX, PlayerIndex+NewShot) = a;

		//yVelocity
		a = Var(RAM_ShipDirection);
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += VarO(RAMO_VelocityY, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityY, PlayerIndex+NewShot) = a;

		//xPosition
		a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, VarO(RAMO_PositionExactX, PlayerIndex), c);
		VarO(RAMO_PositionExactX, PlayerIndex+NewShot) = a;
		Add(tmp8, VarO(RAMO_PositionX, PlayerIndex), c);
		VarO(RAMO_PositionX, PlayerIndex+NewShot) = tmp8;

		//yPosition
		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, VarO(RAMO_PositionExactY, PlayerIndex), c);
		VarO(RAMO_PositionExactY, PlayerIndex+NewShot) = a;
		Add(tmpB, VarO(RAMO_PositionY, PlayerIndex), c);
		VarO(RAMO_PositionY, PlayerIndex+NewShot) = tmpB;*/
		//xPosition
		/*a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, LowByte(PositionX), c);
		LowByte(PositionX) = a;
		Add(tmp8, HighByte(PositionX), c);
		HighByte(PositionX) = tmp8;*/

		//yPosition
/*		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, LowByte(PositionY), c);
		LowByte(PositionY) = a;
		Add(tmpB, HighByte(PositionY), c);
		HighByte(PositionY) = tmpB;*/
	}

	void DoHyperSpace(byte Keys)//sub_6E74
	{
		if(!(Keys & Key_Hyperspace) ||
			NumPlayers == 0 ||
			InvisibleTimer ||
			Objects[PlayerIndex].Status < 0)
			return;

		Objects[PlayerIndex].Status = 0;
		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;
		InvisibleTimer = 0x30;

		byte a = Rand() & 0x1F;
		if(a >= 0x1D)
			a = 0x1C;
		if(a < 3)
			a = 3;
		HighByte(Objects[PlayerIndex].PositionX) = a;
	
		Rand(); Rand(); Rand(); Rand();

		a = Rand() & 0x1F;
		HyperSpaceStatus = 1;
		if(a >= 0x18)
		{
			a &= 7;
			bool c = true;
			ShiftLeft(a, c);
			Add(a, 4, c);
			if(a >= NumAsteroids)//HyperSpace fehlgeschlagen
				HyperSpaceStatus = -128;
		}
		if(a > 0x14)
			a = 0x14;
		if(a < 3)
			a = 3;
		HighByte(Objects[PlayerIndex].PositionY) = a;
	}

	void UpdateHyperspace(byte Keys)//sub_703F
	{
		if(NumPlayers == 0 ||
			Objects[PlayerIndex].Status < 0)
			return;
		if(InvisibleTimer == 0)
		{
			UpdateDirectionAndThrust(Keys);
			return;
		}
		if(--InvisibleTimer)
			return;
		if(char(HyperSpaceStatus) < 0) goto loc_706F;
		if(HyperSpaceStatus) goto loc_7068;
		if(!CanShipAppear()) goto loc_7081;
		if(Objects[SaucerIndex].Status)
		{
			InvisibleTimer = 2;
			return;
		}
loc_7068:
		//Schiff taucht wieder auf
		Objects[PlayerIndex].Status = 1;

		if(TimerBitsKnown < 2)
		{
			//Wenn unser Timer falsch geht und das Schiff zu nem ungnstigen Zeitpunkt
			//auftaucht, kann es sein, dass der Saucercountdown einmal zu viel oder zu
			//wenig aktualisiert wird. Wenn man das unbekannte Bit des Timers klug austauscht,
			//klappts aber. (Klug heit durch Ausprobieren herausgefunden:))
			//Dieser Fall sollte aber eher selten eintreten, nmlich genau dann,
			//wenn am Anfang kein "Push Start" sichtbar war (man noch die Initialen
			//fr den Highscore vom letzten Spiel eintragen musste) UND das Schiff
			//vor dem Auftauchen des ersten UFOs zerstrt wird. Und dann auch nur zu einer
			//Wahrscheinlichkeit von 25% :)
			switch(Timer&3)
			{
			case 0:
				Timer |= 2;
				break;
			case 1: 
				break;
			case 2:
				break;
			case 3: //nicht geprft wenn timer am anfang richtig
				printf("Alles OK %i !!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n", Timer&3);
				MessageBeep(0);
				Timer &= ~2;
				break;
			}
		}

		goto loc_7081;
loc_706F:
		Objects[PlayerIndex].Status = -96;
		NumShips--;
		InvisibleTimer = 0x81;
loc_7081:
		HyperSpaceStatus = 0;
	}

	bool CanShipAppear()
	{
		for(int i = SaucerIndex; i >= 0; i--)
		{
			if(Objects[i].Status == 0)
				continue;

			byte dif = HighByte(Objects[i].PositionX)-HighByte(Objects[PlayerIndex].PositionX);
			if(dif < 0xFC && dif >= 4)
				continue;

			dif = HighByte(Objects[i].PositionY)-HighByte(Objects[PlayerIndex].PositionY);
			if(dif < 0xFC && dif >= 4)
				continue;

			InvisibleTimer++;
			return false;
		}
		return true;
	}

	void UpdateDirectionAndThrust(byte Keys)//loc_7086
	{
		if(Keys & Key_Left)
		{
			ShipDirection += RotationSpeed;
			MaxShipDirection += RotationSpeed;
		}
		else if(Keys & Key_Right)
		{
			ShipDirection -= RotationSpeed;
			MaxShipDirection -= RotationSpeed;
		}
		
		if(Timer & 1)
			return;
		if(Keys & Key_Thrust)
		{
			byte y = 0;
			byte a = ShipDirection;//a=0
			CosLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;   //a=80/FE
			bool c = false;
			Add(a, AccX, c);//a=f9  c=1
			byte x = a;//x=77
			a = y;
			Add(a, Objects[PlayerIndex].VelocityX, c);//a=2
			sub7125(a, x);
			Objects[PlayerIndex].VelocityX = a;
			AccX = x;

			y = 0;
			a = ShipDirection;
			SinLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;
			c = false;
			Add(a, AccY, c);
			x = a;
			a = y;
			Add(a, Objects[PlayerIndex].VelocityY, c);
			sub7125(a, x);
			Objects[PlayerIndex].VelocityY = a;
			AccY = x;
		}
		else
		{
			// KEY_THRUST nicht gedrckt:
			if(Objects[PlayerIndex].VelocityX | AccX)
			{
				byte a = (Objects[PlayerIndex].VelocityX << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccX, c); // Wenn man beide Zeilen durch Add(AccX, a, c); ersetzt optimiert der Microsoft Compiler falsch...
				AccX = a;
				Add((byte&)Objects[PlayerIndex].VelocityX, x, c);
			}
			if(Objects[PlayerIndex].VelocityY | AccY)
			{
				byte a = (Objects[PlayerIndex].VelocityY << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccY, c);
				AccY = a;
				Add((byte&)Objects[PlayerIndex].VelocityY, x, c);
			}
/*		
				char a = Var(RAM_VelocityY)<<1;
				char x = 0xFF;
				a ^= 0xFF;
				bool c = false;
				if(a >= 0)
				{
					x++;
					c = true;
				}
				int sum = int(a)+int(Var(RAM_AccY))+c;
				bool overflow = (sum & 0xFF00) != 0;
				a = sum;
				Var(RAM_AccY) = a;
				a = x;
				a += Var(RAM_VelocityY) + overflow;
				Var(RAM_VelocityY) = a;*/
		}
	}


	void MoveObject(int i)
	{
		//byte tmp4, tmp5, tmp6, tmp7;
		byte a = Objects[i].Status;
		if(a == 0)
			return;
		//loc_6F62
		if(char(a) < 0)
		{
			//Objekt explodiert
			a = ((a^0xFF)+1) >> 4;
//			a = (-a) >> 4;
			bool c = true;
			if(i == PlayerIndex)
			{
				c = (Timer&1) != 0;
				a = 0;
			}
			//loc_6F77
			Add(a, Objects[i].Status, c);
			if(char(a) < 0)
			{//loc_6FA1
				//Objekt explodiert weiter
				Objects[i].Status = a;
				//a = (a&0xF0)+0x10;
				//if(i == PlayerIndex)
				//	a = 0;
				//byte y = a;
				//4567a = VarO(RAMO_PositionExactX, i);
				{//loc_7027
					//sub_72FE
				}
			}
			else if(i == PlayerIndex)
			{//loc_6F93
				ResetPlayerPosition();
				Objects[i].Status = 0;
			}
			else if(i == SaucerIndex)
			{//loc_6F99
				ResetSaucerCountdown(SaucerCountdownStart);
				Objects[i].Status = 0;
			}
			else
			{
				assert(i >= AsteroidMinIndex && i <= AsteroidMaxIndex);
				if(--NumAsteroids == 0)
					NewLevelStartCountdown = 0x7F;
				Objects[i].Status = 0;
			}
			return;
		}
		//loc_6FC7
//		byte y = 0;

		//xPosition += char(VarO(RAMO_VelocityX, i));
		/*a = VarO(RAMO_VelocityX, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactX, i), c);
		VarO(RAMO_PositionExactX, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionX, i), c);*/
//		if(a >= 0x20)//Objekt geht rechts raus

		if(i == SaucerIndex && word(Objects[i].PositionX + Objects[i].VelocityX) >= 0x2000)
		{
			//Das UFO ist ber den Bildschirmrand gelaufen
			//sub_702D
			ResetSaucerCountdown(SaucerCountdownStart);
			Objects[SaucerIndex].Status = 0;
			LowByte(Objects[SaucerIndex].PositionX) = word(Objects[i].PositionX + Objects[i].VelocityX) & 0xFF;
			Objects[SaucerIndex].VelocityX = 0;
			Objects[SaucerIndex].VelocityY = 0;
			return;
		}
		//Objects[i].PositionX = MoveLinearX(Objects[i].PositionX, Objects[i].VelocityX, 1);
//		MakeBytesFromWord(xPosition, VarO(RAMO_PositionX, i), VarO(RAMO_PositionExactX, i));
		//loc_6FEC
		//VarO(RAMO_PositionX, i) = a;

		//Objects[i].PositionY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1);
		Objects[i].MoveLinear(1);
//		MakeBytesFromWord(yPosition, VarO(RAMO_PositionY, i), VarO(RAMO_PositionExactY, i));

/*		y = 0;
		a = VarO(RAMO_VelocityY, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactY, i), c);
		VarO(RAMO_PositionExactY, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionY, i), c);
		if(a >= 0x18)
		{
			if(a == 0x18)
			{//loc_7011
				a = 0;
			}
			else
				a = 0x17;
		}
		//loc_7013
		VarO(RAMO_PositionY, i) = a;*/

		/*a = Objects[i].Status;
		y = 0xE0;
		if((a&1) == 0)
		{
			y = 0xF0;
			if((a&2) == 0)
				y = 0;
		}*/
		//sub_72FE(i);
	}

	/*void RenderObject(int i)//sub_72FE
	{
		byte tmp0 = y;
		bool c = false;
		a = tmp5;
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		tmp5 = a;

		a = tmp7+4;
		c = false;
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		tmp7 = a;
		byte x = 4;
		//sub_7C1C
		a = 0x70;
		a -= tmp0;
		while(char(a) >= -96)
		{
			byte stack = a;
			a = 0x90;
			//sub_7CDE
			a = stack;
			a -= 0x10;
		}
		//loc_733B
		//sub_7CDE
		a = Objects[i].Status;
		if(char(a) >= 0)
		{//loc_735B
		}
		if(i != PlayerIndex)
		{
			y = (a&0x0C)>>1;
//				a = 50F8[y];
//				x = 50F9[y];
			if(x != 0)
			{
				//loc_7370
			}
		}
		{//sub_7465
			
		}
//loc_7384:
		//...
	}*/

	void ResetAsteroids(std::stack<MovePosition<GameRam>>* pMovePositions);


	void ResetPlayerPosition()//sub_71E8
	{
		Objects[PlayerIndex].PositionX = 0x1060;
		Objects[PlayerIndex].PositionY = 0x0C60;

		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;

		Objects[PlayerIndex].SetFixed();
	}

	static void CosLookup(byte& a)//sub_77D2
	{
		a += 0x40;
		SinLookup(a);
	}

	static void SinLookup(byte& a)//sub_77D5
	{
		const byte Table[0x41] =//0x57B9
		{
			0x00, 0x03, 0x06, 0x09, 0x0c, 0x10, 0x13, 0x16, 0x19, 0x1c, 0x1f, 0x22, 0x25, 0x28,
			0x2b, 0x2e, 0x31, 0x33, 0x36, 0x39, 0x3c, 0x3f, 0x41, 0x44, 0x47, 0x49, 0x4c, 0x4e,
			0x51, 0x53, 0x55, 0x58, 0x5a, 0x5c, 0x5e, 0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6b,
			0x6d, 0x6f, 0x70, 0x71, 0x73, 0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f
		};
		bool inv = false;
		if(char(a) < 0)
		{
			inv = true;
			a &= 0x7F;
		}
		if(a >= 0x41)
			a = (a^0x7F) + 1;
		a = Table[a];
		if(inv)
			a = (a^0xFF) + 1;
	}

	void sub7125(byte& a, byte& x)
	{
		if(char(a) >= 0)
		{
			if(a >= 0x40)
			{
				x = 0xFF;
				a = 0x3F;
			}
		}
		else
		{
			if(a < 0xC0)
			{
				x = 1;
				a = 0xC0;
			}
		}
	}

	/*void CloneAsteroid(byte Dest, byte Src)//sub_6A9D
	{
		Objects[Dest] = Objects[Src];
		Objects[Dest].Status = (Objects[Src].Status&7) | (Rand()&0x18);
	}*/

	//Erzeugt zwei kleine Asteroiden
	void SplitAsteroid(int CollisionCauser, int Asteroid, std::stack<MovePosition<GameRam>>* pMovePositions)//sub_75EC
	{
		AsteroidDestroyedTimer = 0x50;
		//byte a = Objects[y].Status;
		//a &= 0x78;
		//byte tmp_e = a;
		byte NewStatus = (Objects[Asteroid].Status&7) >> 1;

		if(RandomSeedDistribution.GetNumSetBits() != 1 &&
			NewStatus)
		{
			//Wir werden gleich neue Asteroiden erstellen, kennen den Seed aber noch nicht
			ChooseRandomSeed(pMovePositions, MPT_ObjectCollision);
			pMovePositions->top().CollisionCauser = CollisionCauser;
			pMovePositions->top().Target = Asteroid;
		}

		if(NumPlayers && (CollisionCauser == PlayerIndex || CollisionCauser >= PlayerShotMinIndex))
		{
			//Der Schuss ist vom Spieler oder der Spieler kollidiert selber mit dem Asteroid -> Punkte
			if(NewStatus == 0)
				AddScore(100);
			else if(NewStatus == 1)
				AddScore(50);
			else if(NewStatus == 2)
				AddScore(20);
			else
				assert(0);
		}
		if(!NewStatus)
			return;
		Objects[Asteroid].Status = (NewStatus | (Objects[Asteroid].Status&0x78));


		CreateSmallAsteroid(Asteroid, true);
		CreateSmallAsteroid(Asteroid, false);
/*		byte NewAsteroid = NextAsteroidSlot(PlayerIndex-1);
		if(NewAsteroid == 0xFF)
		{//////////
			//MessageBeep(0);
#ifdef PRINT_DEBUG_INFO
			printf("Keine Slots mehr uebrig!!\n");
#endif
			return;
		}
		NumAsteroids++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		LowByte(Objects[NewAsteroid].PositionX) ^= (Objects[NewAsteroid].VelocityX&0x1F) << 1;
		NewAsteroid = NextAsteroidSlot(NewAsteroid-1);
		if(NewAsteroid == 0xFF)
		{
			//MessageBeep(0);
#ifdef PRINT_DEBUG_INFO
			printf("Nur noch ein Slot uebrig bei Asteroid %x um %i!!\n", Asteroid, CurrentTime);
#endif
			return;
		}
		NumAsteroids++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		LowByte(Objects[NewAsteroid].PositionY) ^= (Objects[NewAsteroid].VelocityY&0x1F) << 1;*/
	}
	void CreateSmallAsteroid(int BaseAsteroid, bool Type)
	{
		//sub_745A
		int NewAsteroid = AsteroidMaxIndex;
		while(Objects[NewAsteroid].Status)
			if(NewAsteroid-- == AsteroidMinIndex)
			{
#ifdef PRINT_DEBUG_INFO
				printf("Keine Slots mehr fuer neuen Asteroiden uebrig!!\n");
#endif
				return;
			}
		NumAsteroids++;

		//sub_6A9D
		Objects[NewAsteroid] = Objects[BaseAsteroid];
		Objects[NewAsteroid].Status = (Objects[BaseAsteroid].Status&7) | (Rand()&0x18);

		//sub_7203
		byte a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		for(int i = 0; i < Objects[NewAsteroid].cX; i++)
		{
			Objects[NewAsteroid].VX[i] = a + Objects[BaseAsteroid].VX[i];
			ClampVelocity(Objects[NewAsteroid].VX[i]);
		}

		Rand(); Rand(); Rand();

		a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		for(int i = 0; i < Objects[NewAsteroid].cY; i++)
		{
			Objects[NewAsteroid].VY[i] = a + Objects[BaseAsteroid].VY[i];
			ClampVelocity(Objects[NewAsteroid].VY[i]);
		}

		if(Type)
			for(int i = 0; i < Objects[NewAsteroid].cX; i++)
				LowByte(Objects[NewAsteroid].PX[i]) ^= (Objects[NewAsteroid].VX[i] & 0x1F) << 1;
		else
			for(int i = 0; i < Objects[NewAsteroid].cY; i++)
				LowByte(Objects[NewAsteroid].PY[i]) ^= (Objects[NewAsteroid].VY[i] & 0x1F) << 1;
		Objects[NewAsteroid].RemoveEqualities();

	}

	/*byte NextAsteroidSlot(byte StartSearchAt)
	{//sub_745A
		byte i = StartSearchAt;
		while(i!=0xFF && Objects[i].Status)
			i--;
		return i;
	}

	void sub_7203(int x, int y)
	{
		char a = Rand() & 0x8F;
		if(a < 0)
			a |= 0xF0;
		a += Objects[y].VelocityX;
		sub_7233(a);
		Objects[x].VelocityX = a;
	
		Rand(); Rand(); Rand();

		a = Rand() & 0x8F;
		if(a < 0)
			a |= 0xF0;
		a += Objects[y].VelocityY;
		sub_7233(a);
		Objects[x].VelocityY = a;
	}*/

	void ClampVelocity(char& a)//sub_7233
	{
		if(a < 0)
		{
			if(a < -31)
				a = -31;
			else if(a > -6)
				a = -6;
		}
		else
		{
			if(a < 6)
				a = 6;
			else if(a > 31)
				a = 31;
		}
	}

	void AddScore(int ToAdd)
	{//sub_7397
		if(Score/10000 != (Score+ToAdd)/10000)
			NumShips++;
		Score += ToAdd;
	}
	void CheckCollisions(byte CollisionCauser, int FixedTarget, std::stack<MovePosition<GameRam>>* MovePositions);

	static bool AreObjectsNear(byte i, word iPositionX, word iPositionY, byte iStatus,
							   byte j, word jPositionX, word jPositionY, byte jStatus)
	{//Ship/Saucer/Shots mssen in i sein, Asteroiden in j
		byte a = LowByte(jPositionX);
		bool c = true;
		Subtract(a, LowByte(iPositionX), c);
		byte tmp8 = a;
		a = HighByte(jPositionX);
		Subtract(a, HighByte(iPositionX), c);
		ShiftRight(a, c);
		RotateRight(tmp8, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp8 ^= 0xFF;
		}
		a = LowByte(jPositionY);
		c = true;
		Subtract(a, LowByte(iPositionY), c);
		byte tmp9 = a;
		a = HighByte(jPositionY);
		Subtract(a, HighByte(iPositionY), c);
		ShiftRight(a, c);
		RotateRight(tmp9, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp9 ^= 0xFF;
		}
		a = 0x2A;
		ShiftRight(jStatus, c);
		if(!c)
		{
			a = 0x48;
			ShiftRight(jStatus, c);
			if(!c)
				a = 0x84;
		}
		if(i == PlayerIndex)
			a += 0x1C;
		else if(i == SaucerIndex)
		{
			c = true;
			Add(a, 0x12, c);
			if(iStatus != 1)
				Add(a, 0x12, c);
		}
		if(a < tmp8) return false;
		if(a < tmp9) return false;
		byte tmp = a;
		a >>= 1;
		c = false;
		Add(a, tmp, c);
		tmp = a;
		a = tmp9;
		Add(a, tmp8, c);
		if(c) return false;
		if(a >= tmp) return false;
		return true;
	}

	// Gibt zurck, ob sich die Asteroiden oder das UFO gendert haben
	bool OnCollision(int CollisionCauser, int& y, std::stack<MovePosition<GameRam>>* pMovePositions)//sub_6B0F
	{
		bool HaveToDestroyShip = false;//Das Schiff darf nicht vor dem Aufruf von SplitAsteroid zerstrt werden,
								       //da der Zustand durch das Abziehen des Lebens gendert wird und SplitAsteroid
								       //den Zustand per MovePosition wiederherstellen kann.
		if(CollisionCauser != SaucerIndex)
		{
			if(CollisionCauser != PlayerIndex)
			{
				// CollisionCauser ist ein Schuss
				Objects[CollisionCauser].Status = 0; //Schuss lschen
				if(y == PlayerIndex)
					DestroyShip();
				else if(y > PlayerIndex)
					DestroySaucer();
				else
					SplitAsteroid(CollisionCauser, y, pMovePositions);
				Objects[y].Status = -96;
				Objects[y].SetVelocity(0, 0);
				return y != PlayerIndex;
			}
			HaveToDestroyShip = true;
			CollisionCauser = PlayerIndex;
		}
		else if(y == PlayerIndex)
		{
			//Schiff kollidiert mit UFO
			CollisionCauser = PlayerIndex;
			y = SaucerIndex;
			HaveToDestroyShip = true;
		}
		Objects[CollisionCauser].Status = -96;
		Objects[CollisionCauser].SetVelocity(0, 0);
		if(y < PlayerIndex)
		{
			SplitAsteroid(CollisionCauser, y, pMovePositions);
		}
		else
		{
			assert(y == SaucerIndex);
			DestroySaucer();
		}
		Objects[y].Status = -96;
		Objects[y].SetVelocity(0, 0);
		if(HaveToDestroyShip)
			DestroyShip();
		return true;
	}

	void DestroyShip()
	{
		InvisibleTimer = 0x81;
		NumShips--;
	}

	bool UpdateSaucer(std::stack<MovePosition<GameRam>>* pMovePositions, bool InnerMove);//sub_6B93

	byte loc_76F0(byte x, byte y)
	{
		byte a = y;
		if(char(a) < 0)
		{
			a = (a ^ 0xFF) + 1;
			a = loc_76FC(a, x);
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return loc_76FC(a, x);
	}
	byte loc_76FC(byte a, byte x)
	{
		byte y = a;
		a = x;
		if(char(a) < 0)
		{
			a = (a ^ 0xFF) + 1;
			a = sub_770E(a, y);
			a ^= 0x80;
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return sub_770E(a, y);
	}
	byte sub_770E(byte a, byte y)
	{
		byte tmpC = a;
		a = y;	
		if(a == tmpC)
			return 0x20;
		if(a >= tmpC)
		{
			y = tmpC;
			tmpC = a;
			a = y;
			a = sub_7728(a, tmpC, true);
			a -= 0x40;
			a = (a ^ 0xFF) + 1;
			return a;
		}
		else
			return sub_7728(a, tmpC, false);
	}
	byte sub_7728(byte a, byte tmpC, bool c)
	{
		byte tmpB = 0;
		for(int i = 0; i < 4; i++)
		{
			RotateLeft(tmpB, c);
			RotateLeft(a, c);
			c = a >= tmpC;
			if(c)
				Subtract(a, tmpC, c);
		}
		RotateLeft(tmpB, c);

		const byte _772F[0x10] = {0x00, 0x02, 0x05, 0x07, 0x0A, 0x0C, 0x0F, 0x11, 0x13, 0x15, 0x17, 0x19, 0x1A, 0x1C, 0x1D, 0x1F};
		return _772F[tmpB & 0x0F];
	}

	void DestroySaucer()//loc_6B73
	{
		ResetSaucerCountdown(SaucerCountdownStart);
		if(NumPlayers)
		{
			if(Objects[SaucerIndex].Status == 1)
				AddScore(1000);
			else
				AddScore(200);
		}
	}

	void ChooseRandomSeed(std::stack<MovePosition<GameRam>>* pMovePositions, MovePositionType MPT)
	{
		assert(RandomSeedDistribution.GetNumSetBits() > 1);
		int FirstSetIndex = RandomSeedDistribution.GetFirstSetIndex();
		assert(FirstSetIndex != -1);

		MovePosition<GameRam> NewMovePosition(MPT, false);
		NewMovePosition.Game = *this;
		NewMovePosition.Game.RandomSeedDistribution.Set(FirstSetIndex, false);
		pMovePositions->push(NewMovePosition);

		RandomSeedDistribution.ClearAll();
		RandomSeedDistribution.Set(FirstSetIndex, true);
	}

	byte Rand(byte* pRandomSeed2 = 0)
	{
		assert(RandomSeedDistribution.GetNumSetBits() == 1);
		RandomSeedDistribution.RotateRight();
		int Index = RandomSeedDistribution.GetFirstSetIndex();
		if(pRandomSeed2)
			*pRandomSeed2 = RandomSeeds[Index][1];
		return RandomSeeds[Index][0];
		/*bool carry = false;
		ShiftLeft(RandomSeed1, carry);
		if(char(RotateLeft(RandomSeed2, carry)) < 0)
			RandomSeed1++;
		if(RandomSeed1 & 2)
			RandomSeed1 ^= 1;
		if(RandomSeed1 == 0 && RandomSeed2 == 0)
			RandomSeed1++;
		return RandomSeed1;*/
	}

};

#pragma pack(1)

struct FramePacket
{
	word VRam[512];
	byte FrameNo;  // wird bei jedem Frame inkrementiert
	byte Ping;     // Der Server schickt das letzte empfangene ping-byte zurck
	byte Ram[0x300];//Der interne Speicher von Asteroids. Das Mame im Wettbewerb sendet das natrlich nicht. Diente nur zum Debugging
	byte LastRecvKeys;
};

#pragma pack()


class Player
{
public:
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	//void ReceivePacket(FramePacket &packet);
	//void SendPacket(KeysPacket &packet);
};
